//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "OptionsFrm.h"
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TfrmOptions *frmOptions;
//---------------------------------------------------------------------------
__fastcall TfrmOptions::TfrmOptions(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void SetRVFOption(bool Value, TRVFOption Option, TRVFOptions& RVFOptions)
{
  if (Value)
    RVFOptions << Option;
  else
    RVFOptions >> Option;
}
//---------------------------------------------------------------------------
void SetHTMLOption(bool Value, TRVSaveOption Option, TRVSaveOptions& HTMLOptions)
{
  if (Value)
    HTMLOptions << Option;
  else
    HTMLOptions >> Option;
}
//---------------------------------------------------------------------------
void TfrmOptions::GetOptions(TRVFOptions& RVFOptions, TRVSaveOptions& HTMLOptions,
  UnicodeString& HTMLTitle)
{
  RVFOptions  = TRVFOptions();
  HTMLOptions = TRVSaveOptions();
  SetRVFOption(cbRVFSaveBackground->Checked, rvfoSaveBack, RVFOptions);
  SetRVFOption(cbRVFSaveLayout->Checked,     rvfoSaveLayout, RVFOptions);
  SetRVFOption(cbRVFBinary->Checked,         rvfoSaveBinary, RVFOptions);
  SetRVFOption(cbRVFSavePictures->Checked,   rvfoSavePicturesBody, RVFOptions);
  SetRVFOption(cbRVFSaveControls->Checked,   rvfoSaveControlsBody, RVFOptions);
  SetRVFOption(cbRVFLoadBackground->Checked, rvfoLoadBack, RVFOptions);
  SetRVFOption(cbRVFLoadLayout->Checked,     rvfoLoadLayout, RVFOptions);
  SetRVFOption(cbRVFIgnoreUnknownPictures->Checked , rvfoIgnoreUnknownPicFmt, RVFOptions);
  SetRVFOption(cbRVFIgnoreUnknownControls->Checked , rvfoIgnoreUnknownCtrls, RVFOptions);
  SetRVFOption(cbRVFInvStyles->Checked,              rvfoConvUnknownStylesToZero, RVFOptions);
  SetRVFOption(cbRVFInvImageIndices->Checked,        rvfoConvLargeImageIdxToZero, RVFOptions);
  SetRVFOption(cbRVFSaveTextStyles->Checked,  rvfoSaveTextStyles, RVFOptions);
  SetRVFOption(cbRVFSaveParaStyles->Checked,  rvfoSaveParaStyles, RVFOptions);

  SetHTMLOption(cbHTMLOverrideImages->Checked, rvsoOverrideImages, HTMLOptions);
  SetHTMLOption(cbHTMLListAsTest->Checked, rvsoMarkersAsText, HTMLOptions);
  SetHTMLOption(cbHTMLForceNonTextCSS->Checked, rvsoForceNonTextCSS, HTMLOptions);
  SetHTMLOption(cbHTMLDefault0Style->Checked, rvsoDefault0Style, HTMLOptions);
  SetHTMLOption(cbHTMLSaveImageSizes->Checked, rvsoImageSizes, HTMLOptions);
  SetHTMLOption(cbHTMLNoHypertextImageBorders->Checked, rvsoNoHypertextImageBorders, HTMLOptions);
  SetHTMLOption(cbHTMLUseCheckpointsNames->Checked, rvsoUseCheckpointsNames, HTMLOptions);

  HTMLTitle = txtHTMLTitle->Text;
}
//---------------------------------------------------------------------------
void TfrmOptions::SetOptions(TRVFOptions RVFOptions, TRVSaveOptions HTMLOptions,
  const UnicodeString HTMLTitle)
{
  cbRVFSaveBackground->Checked = RVFOptions.Contains(rvfoSaveBack);
  cbRVFSaveLayout->Checked     = RVFOptions.Contains(rvfoSaveLayout);
  cbRVFBinary->Checked         = RVFOptions.Contains(rvfoSaveBinary);
  cbRVFSavePictures->Checked   = RVFOptions.Contains(rvfoSavePicturesBody);
  cbRVFSaveControls->Checked   = RVFOptions.Contains(rvfoSaveControlsBody);
  cbRVFLoadBackground->Checked = RVFOptions.Contains(rvfoLoadBack);
  cbRVFLoadLayout->Checked     = RVFOptions.Contains(rvfoLoadLayout);
  cbRVFIgnoreUnknownPictures->Checked = RVFOptions.Contains(rvfoIgnoreUnknownPicFmt);
  cbRVFIgnoreUnknownControls->Checked = RVFOptions.Contains(rvfoIgnoreUnknownCtrls);
  cbRVFInvStyles->Checked      = RVFOptions.Contains(rvfoConvUnknownStylesToZero);
  cbRVFInvImageIndices->Checked = RVFOptions.Contains(rvfoConvLargeImageIdxToZero);
  cbRVFSaveTextStyles->Checked = RVFOptions.Contains(rvfoSaveTextStyles);
  cbRVFSaveParaStyles->Checked = RVFOptions.Contains(rvfoSaveParaStyles);

  cbHTMLOverrideImages->Checked  = HTMLOptions.Contains(rvsoOverrideImages);
  cbHTMLListAsTest->Checked      = HTMLOptions.Contains(rvsoMarkersAsText);
  cbHTMLForceNonTextCSS->Checked = HTMLOptions.Contains(rvsoForceNonTextCSS);
  cbHTMLDefault0Style->Checked   = HTMLOptions.Contains(rvsoDefault0Style);
  cbHTMLSaveImageSizes->Checked  = HTMLOptions.Contains(rvsoImageSizes);
  cbHTMLNoHypertextImageBorders->Checked = HTMLOptions.Contains(rvsoNoHypertextImageBorders);
  cbHTMLUseCheckpointsNames->Checked = HTMLOptions.Contains(rvsoUseCheckpointsNames);

  txtHTMLTitle->Text = HTMLTitle;
}